<?php
// Busca e exibe outra página da web através de sua URL
$target_url = "https://www.thesportsdb.com/";

// Busca o conteúdo
$content = file_get_contents($target_url);

// Define um array de textos antigos e novos para substituição
$text_replacements = array(
    "../" => "https://www.thesportsdb.com/",
    "/images/icons/calendar.png" => "https://www.thesportsdb.com/images/icons/calendar.png",
    "/images/icons/time.png" => "https://www.thesportsdb.com/images/icons/time.png"
);

// Realiza as substituições de texto
$content = str_replace(array_keys($text_replacements), array_values($text_replacements), $content);

// Adiciona cantos arredondados aos elementos <img> e reduz o tamanho da imagem em 30%
$content = preg_replace_callback('/(<img[^>]+)(>)/i', function($matches) {
    $img_tag = $matches[1];
    $img_tag = preg_replace('/width="(\d+)"/i', '', $img_tag); // Remove o atributo de largura existente
    $img_tag = preg_replace('/height="(\d+)"/i', '', $img_tag); // Remove o atributo de altura existente
    return $img_tag . ' style="border-radius: 10px; max-width: 70%;"' . $matches[2];
}, $content);

// Cria um novo objeto DOMDocument
$dom = new DOMDocument();
libxml_use_internal_errors(true);
$dom->loadHTML($content);
libxml_use_internal_errors(false);

// Aplica cor de texto branca e sombra de texto aos elementos <td>
$xpath = new DOMXPath($dom);
$tdElements = $xpath->query('//td');
foreach ($tdElements as $tdElement) {
    $tdElement->setAttribute('style', 'text-align: left; vertical-align: top; width: 20%; color: white; text-shadow: 1px 1px 2px black;');
}

// Desativa os links clicáveis
$linkElements = $xpath->query('//a');
foreach ($linkElements as $linkElement) {
    $linkElement->removeAttribute('href');
}

// Modifica o estilo do HTML para um fundo semi-transparente
$htmlElement = $xpath->query('//html')->item(0);
if ($htmlElement) {
    $htmlElement->setAttribute('style', 'background-color: rgba(0, 0, 0, 0.5);');
}

// Esconde tudo exceto a tabela
$table = $xpath->query('//table')->item(4);

if ($table) {
    $html = $dom->saveXML($table);
    echo $html;
} else {
    echo "Tabela não encontrada.";
}
?>
